clear

log using log_for_fig7.log

******read in and reshape data from Nekarda LPD********

*use "lpd.dta"



***Only keep those for whom the match score is one over the full 8 interviews***
keep if mvs_8==1

drop msa cbsa mvs_4 mvs_8 match peio1icd peio1ocd cow x*

duplicates drop pid mis, force

reshape wide sswgt sex race age state mdate marstat educ inschool lfs udur wantjob proxy lft samejob hrusl hract ernhrly ernwkly intstat utype, i(pid) j(mis)

save "wide_nekarda_through2013_mvs8.dta", replace


clear

use "wide_nekarda_through2013_mvs8.dta"

***only care about people who have 15-month transition***

drop if lfs8==. | lfs8<0




***Long-term post 2008*******

tab lfs8 [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0, matcell(lt_fig7_m16)

local total_lt = lt_fig7_m16[1,1] + lt_fig7_m16[2,1] + lt_fig7_m16[3,1]

local E_lt = lt_fig7_m16[1,1]/ `total_lt'
local U_lt = lt_fig7_m16[2,1]/ `total_lt'
local N_lt = lt_fig7_m16[3,1]/ `total_lt'

***share E****
di `E_lt' 

****share U****
di `U_lt' 

****share U****
di `N_lt'


***Short-term post 2008*******

tab lfs8 [aweight = sswgt1] if udur1<=26 & udur1>=0 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0, matcell(st_fig7_m16)

local total_st = st_fig7_m16[1,1] + st_fig7_m16[2,1] + st_fig7_m16[3,1]

local E_st = st_fig7_m16[1,1]/ `total_st'
local U_st = st_fig7_m16[2,1]/ `total_st'
local N_st = st_fig7_m16[3,1]/ `total_st'

***share E****
di `E_st' 

****share U****
di `U_st' 

****share U****
di `N_st'




****Deeper dive into month 16 employed***************
***full time all four***
gen emp_and_hours = 1 if (lfs5==1 & lfs6 == 1 & lfs7==1 & lfs8==1) & ((hract5 >= 35 & !missing(hract5)) & (hract6 >= 35 & !missing(hract6)) & (hract7 >= 35 & !missing(hract7)) & (hract8 >= 35 & !missing(hract8)))

****worked all four, at least one part time****
replace emp_and_hours = 2 if (lfs5==1 & lfs6 == 1 & lfs7==1 & lfs8==1) & (hract5 < 35 & !missing(hract5) & hract5>=0 | hract6 < 35 & !missing(hract6) & hract6>=0 | hract7 < 35 & !missing(hract7) & hract7>=0 | hract8 < 35 & !missing(hract8) & hract8>=0 )

***worked less than four*****
replace emp_and_hours = 3 if lfs8==1 & ((lfs5!=1 & !missing(lfs5) & lfs5>0) | (lfs6!=1 & !missing(lfs6) & lfs6>0) | (lfs7!=1 & !missing(lfs7) & lfs7>0))
*replace emp_and_hours = 3 if lfs8==1 & (lfs5==2 | lfs5==3 | lfs6==2 | lfs6==3 | lfs7==2 | lfs7==3 | lfs8==2 | lfs8==3)




label define emp_and_hours 1 "4 months full time" 2 "4 months, some part-time" 3 "less than 4 months"
label values emp_and_hours emp_and_hours



****post 2008, employed in month 16, long-term*****
tab emp_and_hours [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12), matcell(lt_fig7_m13_m15)

local 13to16_lt = lt_fig7_m13_m15[1,1] + lt_fig7_m13_m15[2,1] + lt_fig7_m13_m15[3,1]

local full_lt = lt_fig7_m13_m15[1,1]/ `13to16_lt'
local part_lt = lt_fig7_m13_m15[2,1]/ `13to16_lt'
local onetothree_lt = lt_fig7_m13_m15[3,1]/ `13to16_lt'

***share E****
di `full_lt' 

****share U****
di `part_lt' 

****share U****
di `onetothree_lt'

 

****post 2008, employed in month 16, short-term****
tab emp_and_hours [aweight = sswgt1] if udur1<=26 & udur1>=0 & !missing(udur1) & mdate1>tm(2007m12), matcell(st_fig7_m13_m15)

local 13to16_st = st_fig7_m13_m15[1,1] + st_fig7_m13_m15[2,1] + st_fig7_m13_m15[3,1]

local full_st = st_fig7_m13_m15[1,1]/ `13to16_st'
local part_st = st_fig7_m13_m15[2,1]/ `13to16_st'
local onetothree_st = st_fig7_m13_m15[3,1]/ `13to16_st'

***share E****
di `full_st' 

****share U****
di `part_st' 

****share U****
di `onetothree_st'





**********First four months**********************

gen first_four_stat = 1 if (lfs2==1|  lfs3==1| lfs4==1) & lfs1==2 

replace first_four_stat = 2 if lfs1==2 & (lfs2==2 | lfs3==2 | lfs4==2) & first_four_stat!=1

replace first_four_stat = 3 if lfs1==2 & lfs2==3 & lfs3==3 & lfs4==3

label define first_four_stat 1 "UE firstfour" 2 "Still unemployed" 3 "Dropout"

label values first_four_stat first_four_stat

*******What happened in first four months, initially unemployed******
tab first_four_stat [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12), matcell(lt_fig8_m1_m4)

local total_lt_8 = lt_fig8_m1_m4[1,1] + lt_fig8_m1_m4[2,1] + lt_fig8_m1_m4[3,1]

local toE_lt_8 = lt_fig8_m1_m4[1,1]/ `total_lt_8'
local StillU_lt_8 = lt_fig8_m1_m4[2,1]/ `total_lt_8'
local out_lt_8 = lt_fig8_m1_m4[3,1]/ `total_lt_8'

***share E****
di `toE_lt_8' 

****share U****
di `StillU_lt_8' 

****share U****
di `out_lt_8'


***********************16 months from the beginning by first_four_stat******************
************************************************************
*******U to E first four (i.e. first_four_stat==1***********
tab lfs8 [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0 & first_four_stat==1, matcell(lt_fig8_m16)

local total_toE4 = lt_fig8_m16[1,1] + lt_fig8_m16[2,1] + lt_fig8_m16[3,1]

local toE_E16 = lt_fig8_m16[1,1]/ `total_toE4'
local toE_U16 = lt_fig8_m16[2,1]/ `total_toE4'
local toE_N16 = lt_fig8_m16[3,1]/ `total_toE4'

***share E****
di `toE_E16' 

****share U****
di `toE_U16' 

****share U****
di `toE_N16'


******Still U first four (i.e. first_four_stat==2)**************

tab lfs8 [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0 & first_four_stat==2, matcell(lt_fig8_m16_stillU)

local total_stillU = lt_fig8_m16_stillU[1,1] + lt_fig8_m16_stillU[2,1] + lt_fig8_m16_stillU[3,1]

local stillU_E16 = lt_fig8_m16_stillU[1,1]/ `total_stillU'
local stillU_U16 = lt_fig8_m16_stillU[2,1]/ `total_stillU'
local stillU_N16 = lt_fig8_m16_stillU[3,1]/ `total_stillU'

***share E****
di `stillU_E16' 

****share U****
di `stillU_U16' 

****share U****
di `stillU_N16'


*******drop out first four (i.e. first_four_stat==3)**************

tab lfs8 [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0 & first_four_stat==3, matcell(lt_fig8_m16_dropout)

local total_dropout = lt_fig8_m16_dropout[1,1] + lt_fig8_m16_dropout[2,1] + lt_fig8_m16_dropout[3,1]

local dropout_E16 = lt_fig8_m16_dropout[1,1]/ `total_dropout'
local dropout_U16 = lt_fig8_m16_dropout[2,1]/ `total_dropout'
local dropout_N16 = lt_fig8_m16_dropout[3,1]/ `total_dropout'

***share E****
di `dropout_E16 ' 

****share U****
di `dropout_U16' 

****share U****
di `dropout_N16'

*****************************************
*****************************************
******Detailed 13 to 16 employment record for those who had first_four_stat==1 and were employed in month 16********************

tab emp_and_hours [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0 & first_four_stat==1, matcell(lt_fig8_m13_m16)

local total_toE4_m13_m16 = lt_fig8_m13_m16[1,1] + lt_fig8_m13_m16[2,1] + lt_fig8_m13_m16[3,1]

local toE_full = lt_fig8_m13_m16[1,1]/ `total_toE4_m13_m16'
local toE_part = lt_fig8_m13_m16[2,1]/ `total_toE4_m13_m16'
local toE_1_3 = lt_fig8_m13_m16[3,1]/ `total_toE4_m13_m16'

***share E****
di `toE_full' 

****share U****
di `toE_part' 

****share U****
di `toE_1_3'


*********Detailed 13 to 16 employment record for those who had first_four_stat==2 and were employed in month 16***********************

tab emp_and_hours [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0 & first_four_stat==2, matcell(lt_fig8_stillU_m13_m16)

local total_toE4_m13_m16 = lt_fig8_stillU_m13_m16[1,1] + lt_fig8_stillU_m13_m16[2,1] + lt_fig8_stillU_m13_m16[3,1]

local stillU_full = lt_fig8_stillU_m13_m16[1,1]/ `total_toE4_m13_m16'
local stillU_part = lt_fig8_stillU_m13_m16[2,1]/ `total_toE4_m13_m16'
local stillU_1_3 = lt_fig8_stillU_m13_m16[3,1]/ `total_toE4_m13_m16'

***share E****
di `stillU_full' 

****share U****
di `stillU_part' 

****share U****
di `stillU_1_3'

*********Detailed 13 to 16 employment record for those who had first_four_stat==3 and were employed in month 16***********************

tab emp_and_hours [aweight = sswgt1] if udur1>26 & !missing(udur1) & mdate1>tm(2007m12) & lfs8>0 & first_four_stat==3, matcell(lt_fig8_dropout_m13_m16)

local total_dropout_m13_m16 = lt_fig8_dropout_m13_m16[1,1] + lt_fig8_dropout_m13_m16[2,1] + lt_fig8_dropout_m13_m16[3,1]

local dropout_full = lt_fig8_dropout_m13_m16[1,1]/ `total_dropout_m13_m16'
local dropout_part = lt_fig8_dropout_m13_m16[2,1]/ `total_dropout_m13_m16'
local dropout_1_3 = lt_fig8_dropout_m13_m16[3,1]/ `total_dropout_m13_m16'

***share E****
di `dropout_full' 

****share U****
di `dropout_part' 

****share U****
di `dropout_1_3'

